/*
	
*/
function CTextLine( aParent)
{
	this.parent = aParent;
}

CTextLine.prototype = new Array();
//CTextLine.prototype.CFormulaBase_Create = Array.prototype.Create;

CTextLine.prototype.EL_MAX 		= -1; // ,      
CTextLine.prototype.EL_NO 		= -2; // ,    

//  
CTextLine.prototype.bPara 		= 1; // true - ,    -  
CTextLine.prototype.visible 	= true;
CTextLine.prototype.parent 		= null;
CTextLine.prototype.posY 		= 0;

//
CTextLine.prototype.clear = function()
{
	for ( var i = 0; i < this.length; i++)
	{
		var elem = this[ i];
		elem.clear();
		elem = null;
	}
	this.length = 0;
}

//
CTextLine.prototype.createElem = function( aParent, aElemID, pos)
{
	var elem	= new CElem( aParent);
	elem.id		= aElemID;
	this.splice( pos, 0, elem);
}

//
CTextLine.prototype.getElem = function( i)
{
	if ( i >= 0 && i < this.length)
		return this[ i];
	return null;
}

//
CTextLine.prototype.getNextElemNumber = function( bNext, elemNumber)
{
	if ( this.length == 0)
	{
		trace( "#aa0000 ERROR::CTextLine::getNextElemNumber::this.length == 0");
		return this.EL_NO;
	}
	if ( elemNumber == this.EL_MAX)
	{
		elemNumber = this.length - 1;
		var elem = this.getElem( elemNumber);
		if ( elem.type == elem.ELTYPE_SPLIT || elem.type == elem.ELTYPE_LINE)
			return elemNumber - 1;
		return elemNumber;
	}
	if ( bNext)
	{
		elemNumber++;
		var elem = this.getElem( elemNumber);
		if ( elem == null)
			return null;
		if ( elem.type == elem.ELTYPE_SPLIT || elem.type == elem.ELTYPE_LINE)
			return this.EL_MAX;
		return elemNumber;
	}
	else
	{
		elemNumber--;
		var elem = this.getElem( elemNumber);
		if ( elem == null)
			return null;
		return elemNumber;
	}
}

//
CTextLine.prototype.getNextElem = function( bNext, elemNumber)
{
	if ( this.length == 0)
	{
		trace( "#aa0000 ERROR::CTextLine::getNextElem::this.length == 0");
		return this.EL_NO;
	}
	if ( elemNumber == this.EL_MAX)
	{
		elemNumber = this.length - 1;
		var elem = this.getElem( elemNumber);
		if ( elem == null)
			return null;
		if ( elem.type == elem.ELTYPE_SPLIT || elem.type == elem.ELTYPE_LINE)
			return this.getElem( elemNumber - 1);
		return elem;
	}
	if ( bNext)
	{
		elemNumber++;
		var elem = this.getElem( elemNumber);
		if ( elem == null)
			return null;
		if ( elem.type == elem.ELTYPE_SPLIT || elem.type == elem.ELTYPE_LINE)
			return this.EL_MAX;
		return elem;
	}
	else
	{
		elemNumber--;
		var elem = this.getElem( elemNumber);
		if ( elem == null)
			return null;
		return elem;
	}
}
CTextLine.prototype.getY = function()
{
	return this.posY;
}

CTextLine.prototype.setY = function( aPosY)
{
	this.posY = aPosY;
	for ( var i = 0; i < this.length; i++)
	{
		var elem = this[ i];
		elem.setY( this.posY);
	}
}

CTextLine.prototype.getWidth = function()
{
	var elem = this.getNextElem( false, this.EL_MAX);
	if ( elem == this.EL_NO)
		return 0;
	if ( elem == null)
	{
		trace( "#aa0000 ERROR::CTextLine::getWidth::elem == null");
		return 0;
	}
	return elem.getX() + elem.getWidth();
}

CTextLine.prototype.getHeight = function()
{
	return this.parent.getLineHeight();
}

CTextLine.prototype.show = function()
{
	for ( var i = 0; i < this.length; i++)
	{
		var elem = this[ i];
		elem.show();
	}
	this.visible = true;
}

CTextLine.prototype.hide = function()
{
	for ( var i = 0; i < this.length; i++)
	{
		var elem = this[ i];
		elem.hide();
	}
	this.visible = false;
}

CTextLine.prototype.getBounds = function( aParent)
{
	bounds = new Object();
	var aHeight = this.parent.getLineHeight();
	var aWidth = this.getWidth();
	if ( aWidth == 0)
	{
		bounds.xMin = 0;
		bounds.xMax = 1;
		bounds.yMin = this.posY;
		bounds.yMax = this.posY + aHeight;
		return bounds;
	}
	var elem = this[ 0];
	bounds.xMax = elem.getX() + aWidth;
	bounds.yMin = elem.getY();
	bounds.yMax = elem.getY() + aHeight;
	return bounds;
}
