function CLabReport( aReportHeaderComp, aLabExpReportComp)
{
	this.reportHeaderComp = aReportHeaderComp;
	this.labExpReportComp = aLabExpReportComp;
}

CLabReport.prototype.labDataFile	= null;
CLabReport.prototype.basePath		= '';
CLabReport.prototype.baseDataPath	= '';
CLabReport.prototype.testExist		= false;
CLabReport.prototype.test2Exist		= false;
CLabReport.prototype.editTeachMark	= false;

CLabReport.prototype._setReportXml = function( xml)
{
	trace( "#00AA00 CLabReport::_setReportXml");
	var node;
	this.beginReportTag = '<' + xml.name + '>';
	this.endReportTag = '';
	for ( var i = 0;  i < xml.contents.length;  i++)
	{
		node = xml.contents[ i];
		if ( node.type == 'element')
		{
			if ( node.name == 'personal')
				this._setPersonalXML( node);
			else if ( node.name == 'lab')
				this._setLabXML( node);
		}
	}
	this.endReportTag += '</' + xml.name + '>';
}

CLabReport.prototype._getDate = function()
{
	var date_ = new Date();
	var day = date_.getDate();
	trace( "#aa0000 CLabReport::_getDate::day = "+day);
	var month = date_.getMonth();
	var year = date_.getYear();
	year += 1900;

	if ( month == 2 && year % 4 == 0)
	{
		if ( day > 29)
			day -= 29;
	}
	else if ( month == 2)
	{
		if ( day > 28)
			day -= 28;
	}
	else if ( month == 4 || month == 6 || month == 9 || month == 11)
	{
		if ( day > 30)
			day -= 30;
	}
	else if ( day > 31)
			day -= 31;

	month += 1;

	if ( day < 10)
		day = "0" + day;
	if ( month < 10)
		month = "0" + month;
	return day + "." + month + "." + year;
}

CLabReport.prototype._setPersonalXML = function( xml)
{
	trace( "#00AA00 CLabReport::_setPersonalXML");
	var node;
	var __userName = "";
	var __userClass = "";
	this.beginReportTag += '<' + xml.name + '>';
	for ( var i = 0;  i < xml.contents.length;  i++)
	{
		node = xml.contents[ i];
		if ( node.type == 'element')
		{
			if ( node.name == 'name')
			{
				this.beginReportTag += '<' + node.name +'>%userName%</' + node.name +'>';
				if ( node.innerToString().length != 0)
				{
					//removePrompt( this.reportPane.all.userName);
					//this.reportPane.all.userName.value = node.innerToString();
					__userName = node.innerToString();
				}
			}
			else if ( node.name == 'class')
			{
				this.beginReportTag += '<' + node.name +'>%userClass%</' + node.name +'>';
				if (node.innerToString().length != 0)
				{
					//removePrompt( this.reportPane.all.userClass);
					//this.reportPane.all.userClass.value = node.innerToString();
					__userClass = node.innerToString();
				}
			}
		}
	}
	var date = this._getDate();
	var val = ": " + date;
	this.beginReportTag += '<date>' + date + '</date>';
	//this.reportPane.all.date.innerHTML = date;
	this.beginReportTag += '</' + xml.name + '>';

	this.reportHeaderComp.init( " ", __userName, __userClass, val);
}

CLabReport.prototype._setLabXML = function( xml)
{
	trace( "#00AA00 CLabReport::_setLabXML");
	var node;
	var text;
	var re = /\&\|/g;
	this.labExpReportComp.id = xml.attributes.id;
	//this.reportPane.all.labId.innerHTML = xml.attributes.id;

	this.beginLabTag = '<' + xml.name + ' id="' + xml.attributes.id + '">';
	this.endLabTag = '';
	for ( var i = 0;  i < xml.contents.length;  i++)
	{
		node = xml.contents[ i];
		if ( node.type == 'element')
		{
			if ( node.name == 'exp')
			{
				this._setExpXML( node);
			}
			else if ( node.name == 'name')
			{
				text = node.innerToString();
				this.beginLabTag += '<' + node.name +'>' + text + '</' + node.name +'>';
				//this.reportPane.all.labName.innerHTML = text.replace( /^ \s*/, "");;
				this.reportHeaderComp.setTheme( text.replace( /^ \s*/, ""));
				if ( text.length == 0)
				{
					//this.reportPane.all.labNameQuot.style.display = 'none';
					//this.reportPane.all.labGoalFull.style.display = 'none';
					//this.reportPane.all.test2Full.style.display = 'none';
					//this.reportPane.all.testMarkTable.style.display = 'none';
				}
			}
			else if ( node.name == 'safety_test')
			{
				text = node.innerToString();
				this.test2Exist = (text.length > 0);
				//this.reportPane.all.test2Mark.innerHTML = text;
			}
			else if ( node.name == 'test')
			{
				text = node.innerToString();
				this.testExist = (text.length > 0);
				//this.reportPane.all.testMark.innerHTML = text.replace( re, '\n');
			}
			else if ( node.name == 'goal')
			{
				text = node.innerToString();
				//this.reportPane.all.labGoal.value = text.replace( re, '\n');
			}
			else if ( node.name == 'data')
			{
				this.labDataFile = node.attributes.file;
				var pos = -1;
				if ( typeof( this.labDataFile) == 'string')
				{
					//trace( "CLabReport::_setLabXML::this.labDataFile = " + this.labDataFile);
					this.labDataFile = this.labDataFile.replace( /\\/g, '/');
					this.labDataFile = this.labDataFile.replace( /\/\//g, '/');
					this.labDataFile = this.labDataFile.replace( /\/\//g, '/');
					pos = this.labDataFile.lastIndexOf( '/');
				}
				if ( pos == -1)
					this.baseDataPath = '';
				else
					this.baseDataPath = this.labDataFile.substr( 0, pos + 1);
				this.beginLabTag += node.toString();
			}
			else if ( node.name == 'teach_mark')
			{
				this._setMarkXML( node);
			}
		}
	}
	this.endLabTag += '</' + xml.name + '>';
}

CLabReport.prototype._setExpXML = function( xml)
{
	trace( "#00AA00 CLabReport::_setExpXML");
	var re = /\&\|/g;
	var node, rowNode;

	var question, comment, formulas, observation, image, imageW, imageH, chemEditor, isLoaded;
	if ( typeof( xml.attributes.loaded) == 'undefined')
		isLoaded = '1';
	else
		isLoaded = xml.attributes.loaded;

	if ( typeof( xml.attributes.chemEditor) == 'undefined')
		chemEditor = '1';
	else
		chemEditor = xml.attributes.chemEditor;
	trace( "CLabReport::_setExpXML::chemEditor = " + chemEditor);
	//
	this.beginExpTag = '<' + xml.name + ' id="' + xml.attributes.id + '"' +
						(isLoaded == "0" ? ' loaded="0">' : ' chemEditor="' + chemEditor + '">');
	this.endExpTag = '';

	if ( chemEditor == "1")
	{
		if ( typeof( scene.oChemEditor) == "undefined")
		{
			scene.oChemEditor = new Composition();
			scene.oChemEditor._class = "CWinChemEditor";
			scene.oChemEditor.parent = scene;
			scene.oChemEditor.labDataFile = this.labDataFile;
			scene.editor = scene.oChemEditor;
		}
	}

	for ( var i = 0;  i < xml.contents.length;  i++)
	{
		node = xml.contents[ i];
		if ( node.type == 'element')
		{
			trace( "CLabReport::_setExpXML::node.name = " + node.name);
			if ( node.name == 'row')
			{
				question = '';
				comment = '';
				observation = '';
				image = '';
				imageW = null;
				imageH = null;
				formulas = new Array();
				for ( var j = 0;  j < node.contents.length;  j++)
				{
					rowNode = node.contents[ j];
					if ( rowNode.type == 'element')
					{
						if ( rowNode.name == 'formula')
							formulas[ formulas.length] = rowNode.attributes.id;
						else if ( rowNode.name == 'comment')
						{
							//comment = rowNode.innerToString();
							if ( rowNode.contents.length > 0)
								comment = rowNode.contents[ 0];
						}
						else if ( rowNode.name == 'observation')
						{
							observation = rowNode.innerToString();
							image = rowNode.attributes.image;
							imageW = Number( rowNode.attributes.imageWidth);
							imageH = Number( rowNode.attributes.imageHeight);
						}
						else if ( rowNode.name == 'question')
						{
							question = rowNode.innerToString();
						}
					}
				}
				//comment = comment.replace( re, '\n');
				observation = observation.replace( re, '\n');
				//
				var exp = this.addExp( xml.attributes.id, '', chemEditor == "1", isLoaded == "0");
				this.addExpRow( exp, question, comment,
									formulas, image, observation, imageW, imageH);
			}
			else if ( node.name == 'name')
			{
				this.beginExpTag += '<' + node.name +'>' + node.innerToString() + '</' + node.name +'>';
				//exp.setName( node.innerToString());
				//exp.all.expName.innerHTML = node.innerToString();
			}
			else if ( node.name == 'formula_gallery')
			{
				var data = node.toString();
				scene.oChemEditor.setFormulaGalleryData( data);
			}
			else if ( node.name == 'conclusion')
			{
				//exp.all.conclusion.value = node.innerToString().replace( re, '\n');
				trace( "CLabReport::_setExpXML::node.name == 'conclusion'");
				this.labExpReportComp.labConclusion.initialize( node.innerToString());
			}
		}
	}
	if ( typeof( scene.oChemEditor) != "undefined" && scene.oChemEditor != null
		&& typeof( scene.oChemEditor.formulaGalleryData) == 'undefined')
	{
		scene.oChemEditor.setFormulaGalleryData( '');
		this.addExp( null, '', chemEditor == "1", isLoaded == "0");
	}
	else if ( typeof( scene.oChemEditor) == "undefined" || scene.oChemEditor == null)
	{
		if ( this.labExpReportComp.getCount() == 0)
			this.addExp( null, '', chemEditor == "1", isLoaded == "0");
	}
	this.endExpTag += '</' + xml.name + '>';
	this.labExpReportComp.reset();
	//this.reportPane.updateScrollBar();
}

CLabReport.prototype._setMarkXML = function( xml)
{
	var node;
	if ( this.editTeachMark == false)
	{
		//this.reportPane.all.teachMark.style.display = 'none';
		//this.reportPane.all.teachComment.style.display = 'none';
		//this.reportPane.all.teachMarkText.style.display = 'inline';
		//this.reportPane.all.teachCommentText.style.display = 'inline';
	}
	else
	{
		//this.reportPane.all.teachMark.style.display = 'inline';
		//this.reportPane.all.teachComment.style.display = 'inline';
		//this.reportPane.all.teachMarkText.style.display = 'none';
		//this.reportPane.all.teachCommentText.style.display = 'none';
	}
	for ( var i = 0;  i < xml.contents.length;  i++)
	{
		node = xml.contents[ i];
		if ( node.type == 'element')
		{
			if ( node.name == 'mark')
			{
				//this.reportPane.all.teachMark.value = node.innerToString();
				//this.reportPane.all.teachMarkText.innerHTML = node.innerToString();
			}
			else if ( node.name == 'comment')
			{
				//this.reportPane.all.teachComment.value = node.innerToString();
				//this.reportPane.all.teachCommentText.innerHTML = node.innerToString();
			}
		}
	}
}

CLabReport.prototype.initReport = function( sXMLData)
{
	trace( "#00AA00 CLabReport::initReport");
	this.xml = Xparse( sXMLData);
	//this.xml = new XML();
	//this.xml.value = sXMLData;
	//var node;
	//var XMLF = this.xml.XMLDocument.childNodes;
	trace( "#00AA00 CLabReport::initReport this.xml.contents.length = " + this.xml.contents.length);
	for ( var i = 0;  i < this.xml.contents.length;  i++)
	{
		node = this.xml.contents[ i];
		if ( node.type == 'element' && node.name == 'report')
			this._setReportXml( node);
	}
}

//
CLabReport.prototype.editTeacherMark = function()
{
	this.editTeachMark = true;
//	this.reportPane.all.teachMark.style.display = 'inline';
//	this.reportPane.all.teachMarkText.style.display = 'none';
//	this.reportPane.all.teachComment.style.display = 'inline';
//	this.reportPane.all.teachCommentText.style.display = 'none';
}

//
CLabReport.prototype.getReportXML = function()
{
	trace( "#00AA00 CLabReport::getReportXML");
	var xml = this.beginReportTag.replace( /\%userName\%/g,
									 this.reportHeaderComp.getUserName()).replace(
											/\%userClass\%/g,
											this.reportHeaderComp.getUserClass()) + this.beginLabTag;
	trace( "CLabReport::getReportXML::xml = " + xml);
	xml += '<goal></goal>';
	xml += '<safety_test></safety_test>';

	var exp;
	var galleryData = "";
	var expNumber = this.labExpReportComp.getCount();
	trace( "#00aa00 CLabReport::getReportXML::expNumber = " + expNumber);
	xml += this.beginExpTag;
	if ( typeof( scene.oChemEditor) != "undefined" && scene.oChemEditor != null)
	{
		galleryData = scene.oChemEditor.formulaGalleryData.getData();
		galleryData = galleryData.replace( /\</gi, '{');
		galleryData = galleryData.replace( /\>/gi, '}');
	}

	trace( "#00aa00 CLabReport::getReportXML::galleryData.length = " + galleryData.length);
	if ( galleryData.length > 2)
	{
		//galleryData = galleryData.substr( 1, galleryData.length - 2);
		xml += '<formula_gallery>' + galleryData + '</formula_gallery>';
	}

	for ( var i = 0;  i < expNumber;  i++)
	{
		exp = this.getExp( i);
		trace( "#00aa00 CLabReport::getReportXML::i = " + i);
		xml += exp.getData();
	}
	var value = this.labExpReportComp.labConclusion.getValue();
		xml += '<conclusion>' + value + '</conclusion>';

	xml += this.endExpTag;

	var re = /=(\w+)/gi;
	xml += '<test>' + "" + '</test>';
	xml += '<teach_mark><mark>' + "" + '</mark><comment>'
				+ '</comment></teach_mark>';
	xml += this.endLabTag + this.endReportTag;
	var re = /\r\n/g;
	xml = xml.replace( re, '\&\|');
	return xml;
}

CLabReport.prototype.saveReport = function()
{
	trace( "#00aa00 CLabReport::saveReport");
	var re1 = /(%|")/g;
	var re2 = /(\n\r)|(\r\n)|(\n)/g;
	var s = this.getReportXML();
	//trace( "CLabReport::saveReport::s = "+s);
	this.reportHeaderComp.parent.save_report( s);
}


CLabReport.prototype.addExpRow = function( exp, question, comment, reactions, image, observation, imageW, imageH)
{
	trace( "#00aa00 CLabReport::addExpRow::empty");
	exp.fill( question, comment, reactions, image, observation, imageW, imageH);
}

//
CLabReport.prototype.addExp = function( aExpId, aExpName, aEnChemEdit, aNotLoaded)
{
	trace( "#00aa00 CLabReport::addExp");
	return this.labExpReportComp.createExpByDefault( aExpId, aExpName, aEnChemEdit, aNotLoaded);
}

CLabReport.prototype.getExp = function( aExp)
{
	return this.labExpReportComp.getLabExp( aExp);
}