function CLabChemEqualsParser( aChemViewer, aChemEditor, anImageGalleryPane)
{
	this.chemViewer = aChemViewer;
	this.chemEditor = aChemEditor;
}

CLabChemEqualsParser.prototype.activeExp			= null;
CLabChemEqualsParser.prototype.activeExpId			= '';
CLabChemEqualsParser.prototype.basePath				= '';
CLabChemEqualsParser.prototype.baseDataPath			= '';
CLabChemEqualsParser.prototype.expNumber			= 0;
CLabChemEqualsParser.prototype.formulaGalleryData	= null;
CLabChemEqualsParser.prototype.activeFormulaName	= null;


CLabChemEqualsParser.prototype.sendGalleryToChemEditor = function()
{
	this.chemEditor.call( 'SetVariable', 'galleryData',
							'<formula_gallery>' + this.activeExp.formulaGalleryData.data + '</formula_gallery>');
}

CLabChemEqualsParser.prototype.setActiveExp = function( aExp)
{
	var oldActiveExp = this.activeExp;
	if ( oldActiveExp != aExp)
	{
		this.activeExp = aExp;
		//this.activeExpId = aExp.all.expId.innerHTML;
		//this.chemEditor.SetVariable( 'expId', this.activeExpId);

		//setTimeout( 'report.updateAllViewers()', 50);
		//setTimeout( 'report.sendGalleryToChemEditor()', 70);

		//this.editingViewer = null;
		//this.reportPane.scrollTop = this.activeExp.offsetTop - this.reportPane.offsetHeight / 2 - 55;
	}
}

CLabChemEqualsParser.prototype.setFormulaGalleryData = function( aData, anExp)
{
	var exp = ( typeof( anExp) == 'undefined' ? this.activeExp : anExp);

	var galleryData = aData;
	galleryData = galleryData.replace( /\<formula_gallery\>/gi, '');
	galleryData = galleryData.replace( /\<\/formula_gallery\>/gi, '');
	galleryData = galleryData.replace( /\{/gi, '<');
	galleryData = galleryData.replace( /\}/gi, '>');

	trace( "CLabChemEqualsParser::setFormulaGalleryData::galleryData = " + galleryData);
	//if ( galleryData.length < 3 && exp.formulaGalleryData != null)
		//return;

	if ( exp.formulaGalleryData != null)
	{
		exp.formulaGalleryData.names.length = 0;
		exp.formulaGalleryData.names = null;
		exp.formulaGalleryData.data = null;
		exp.formulaGalleryData = null;
	}
	exp.formulaGalleryData = new Object();
	exp.formulaGalleryData.data = galleryData;
	exp.formulaGalleryData.names = new Array();
	exp.formulaGalleryData.getData = function()
	{
		var aGalleryData = this.data;
		if ( aGalleryData[ 0] == "'" && aGalleryData[ aGalleryData.length - 1] == "'")
			aGalleryData = aGalleryData.substr( 1, aGalleryData.length - 2);
		else if ( aGalleryData[ 0] == "'" )
			aGalleryData = aGalleryData.substr( 1, aGalleryData.length - 1);
		else if ( aGalleryData[ aGalleryData.length - 1] == "'" )
			aGalleryData = aGalleryData.substr( 0, aGalleryData.length - 1);
		return aGalleryData;
	}

	var arFormulas = galleryData.split( '</formula>');
	var id, width, height, arMatch;
	var bValid = false;
	for ( var i = 0;  i < arFormulas.length;  i++)
	{
		trace( "CLabChemEqualsParser::setFormulaGalleryData::arFormulas[ i].length = "+arFormulas[ i].length);
		if ( i == 0)
		{
			var arFormula = arFormulas[ i];
			if ( arFormula[ 0] == "'" && arFormula[ arFormula.length - 1] == "'")
				arFormula = arFormula.substr( 1, arFormula.length - 2);
			else if ( arFormula[ 0] == "'" )
				arFormula = arFormula.substr( 1, arFormula.length - 1);
			else if ( arFormula[ arFormula.length - 1] == "'" )
				arFormula = arFormula.substr( 0, arFormula.length - 1);
			arFormulas[ i] = arFormula;
			//arFormulas[ i] = arFormulas[ i].substr( 1, arFormulas[ i].length - 1);
		}

		if ( arFormulas[ i].length > 0)
		{
			arFormulas[ i] += '</formula>';
			arMatch = arFormulas[ i].match( /<formula [^>]*id="([^"]+)"/i);
			if ( arMatch != null)
			{
				id = arMatch[ 1];
				arMatch = arFormulas[ i].match( /<formula [^>]*width="([^"]+)"/i);
				if ( arMatch != null)
					width = arMatch[ 1];
				else
					width = '100%';
				arMatch = arFormulas[ i].match( /<formula [^>]*height="([^"]+)"/i);
				if ( arMatch != null)
					height = arMatch[ 1];
				else
					height = 75;
				exp.formulaGalleryData.names[ exp.formulaGalleryData.names.length] = id;
				exp.formulaGalleryData[ id] = arFormulas[ i];
				trace( "CLabChemEqualsParser::setFormulaGalleryData::exp.formulaGalleryData[ " + id + "] = " + exp.formulaGalleryData[ id]);
				exp.formulaGalleryData[ id + '_width'] = width;
				exp.formulaGalleryData[ id + '_height'] = height;
				if ( !bValid)
					bValid = true;
			}
		}
		if ( bValid)
			this.activeExp = exp;
	}
}

CLabChemEqualsParser.prototype.getActiveExp = function()
{
	return this.activeExp;
}

CLabChemEqualsParser.prototype.getFormulaGalleryData = function()
{
	if ( this.activeExp != null)
		return this.activeExp.formulaGalleryData;
	return null;
}

CLabChemEqualsParser.prototype.findFormulaByName = function( aFormulaName)
{
	if ( this.activeExp != null && this.activeExp.formulaGalleryData != null)
	{
		for ( var expID = 0; expID < this.activeExp.formulaGalleryData.names.length; expID++)
		{
			var aFormulaName__ = this.activeExp.formulaGalleryData.names[ expID];
			if ( aFormulaName == aFormulaName__)
				return expID;
		}
	}
	return -1;
}

CLabChemEqualsParser.prototype.getFormulaID = function()
{
	if ( this.activeExp != null && this.activeExp.formulaGalleryData != null)
	{
		for ( var expID = 0; expID < this.activeExp.formulaGalleryData.names.length; expID++)
		{
			var aFormulaName = this.activeExp.formulaGalleryData.names[ expID];
			if ( this.activeFormulaName == aFormulaName)
				return expID;
		}
	}
	return -1;
}

CLabChemEqualsParser.prototype.getFormula = function()
{
	if ( this.activeExp != null && this.activeExp.formulaGalleryData != null)
	{
		for ( var expID = 0; expID < this.activeExp.formulaGalleryData.names.length; expID++)
		{
			var aFormulaName = this.activeExp.formulaGalleryData.names[ expID];
			if ( this.activeFormulaName == aFormulaName)
				return this.activeExp.formulaGalleryData[ aFormulaName];
		}
	}
	return "";
}

CLabChemEqualsParser.prototype.getFormulaByName = function( aFormulaName)
{
	if ( typeof( aFormulaName) == "undefined" || aFormulaName == null)
		return null;

	trace( "CLabChemEqualsParser::getFormulaByName::this.activeExp = " + this.activeExp);
	trace( "CLabChemEqualsParser::getFormulaByName::this.activeExp.name = " + this.activeExp.name);
	trace( "CLabChemEqualsParser::getFormulaByName::this.activeExp.formulaGalleryData = " + this.activeExp.formulaGalleryData);

	if ( this.activeExp != null && this.activeExp.formulaGalleryData != null)
		return this.activeExp.formulaGalleryData[ aFormulaName];
	return null;
}

CLabChemEqualsParser.prototype.setActiveFormulaName = function( abActiveFormulaName)
{
	this.activeFormulaName = abActiveFormulaName;
}

CLabChemEqualsParser.prototype.getActiveFormulaName = function()
{
	return this.activeFormulaName;
}

CLabChemEqualsParser.prototype.isActiveFormulaName = function()
{
	return this.activeFormulaName != null && this.activeFormulaName.length > 0 && this.activeFormulaName != "";
}

CLabChemEqualsParser.prototype.getActiveFormula = function()
{
	return this.activeExp.formulaGalleryData[ this.activeFormulaName];
}