//////////////////////////////////////////////////////////////////
//    ,  CAtom,   
//  
//////////////////////////////////////////////////////////////////
function CCycleAtom()
{
	this.myCycle = null;	//    
	this.cycleIndex=0;		//      
	this.isTail = false;	//     
	////////////////////////////////////////////////
	this.children=new Array();
	this.type="C";
	this.parent=null;
	this.drawType=1;
	this.x=0;
	this.y=0;
	this.rootDistance=0;
	this.linkType=0;
	this.freeLinks=4;
	this.firstChildDirection="down";
	this.molecule=null;
	this.oText=null;
	this.oLink=null;
	this.longestChild=null;
	this.longestChildCount=0;
	this.isOnMainLine=false;
	this.subtreeLength=0;
	this.isFlipped=false;	//    180 .?
}
CCycleAtom.prototype = new CAtom();

//   - 
CCycleAtom.prototype.create = function(atomType)
{
	var newAtom = new CCycleAtom();
	newAtom.type = atomType;
	newAtom.linkType = 1;
	return newAtom;
}

//     
CCycleAtom.prototype.CAtom_addChild = CAtom.prototype.addChild;
CCycleAtom.prototype.addChild = function(atom)
{
	this.myCycle.children.push( atom);
	return this.CAtom_addChild( atom);
}
//   
CCycleAtom.prototype.CAtom_removeChild = CAtom.prototype.removeChild;
CCycleAtom.prototype.removeChild = function(atom)
{
	this.myCycle.removeChild( atom);
	return this.CAtom_removeChild( atom);
}

//     
CCycleAtom.prototype.CAtom_getCommonChildDirectionsFor = CAtom.prototype.getCommonChildDirectionsFor;
CCycleAtom.prototype.getCommonChildDirectionsFor = function(atom)
{
trace( "getCommonChildDirections="+this.myCycle.firstChildDirection);
	var add = new Array();
	var cycleFCD = this.myCycle.firstChildDirection;

	var rotateCount = 0;
	var	sides = new Array("up","right-up","right","right-down","down","left-down","left","left-up");

	if( this.myCycle.cycleType == 6)
	{
		if( this.children.length > 2)
		{
			if( this.cycleIndex==0){ add.push("right-up"); add.push("left-up");}
			else	if( this.cycleIndex==1){ add.push("left");	add.push("left-up");}
			else	if( this.cycleIndex==2){ add.push("left-down");	add.push("left");}
			else	if( this.cycleIndex==3){ add.push("left-down");	add.push("right-down");}
			else	if( this.cycleIndex==4){ add.push("right-down");	add.push("right");}
			else	if( this.cycleIndex==5){ add.push("right");	add.push("right-up");}
		}
		else
		{
			if( this.cycleIndex==0){ add.push("up");}
			else	if( this.cycleIndex==1){ add.push("left-up");}
			else	if( this.cycleIndex==2){ add.push("left-down");}
			else	if( this.cycleIndex==3){ add.push("down");}
			else	if( this.cycleIndex==4){ add.push("right-down");}
			else	if( this.cycleIndex==5){ add.push("right-up");}
		}
	}
	else	if( this.myCycle.cycleType == 5)
	{
		if( this.children.length > 2)
		{
			if( this.cycleIndex==0){ add.push("right-up"); add.push("left-up");}
			else	if( this.cycleIndex==1){ add.push("left");	add.push("left-up");}
			else	if( this.cycleIndex==2){ add.push("left-down");	add.push("left");}
			else	if( this.cycleIndex==3){ add.push("right-down");	add.push("right");}
			else	if( this.cycleIndex==4){ add.push("right");	add.push("right-up");}
		}
		else
		{
			if( this.cycleIndex==0){ add.push("up");}
			else	if( this.cycleIndex==1){ add.push("left-up");}
			else	if( this.cycleIndex==2){ add.push("left-down");}
			else	if( this.cycleIndex==3){ add.push("right-down");}
			else	if( this.cycleIndex==4){ add.push("right-up");}
		}
	}
	else	if( this.myCycle.cycleType == 4)
	{
		if( this.children.length > 2)
		{
			if( this.cycleIndex==0){ add.push("right-up"); add.push("left-up");}
			else	if( this.cycleIndex==1){ add.push("left-up");	add.push("left-down");}
			else	if( this.cycleIndex==2){ add.push("left-down");	add.push("right-down");}
			else	if( this.cycleIndex==3){ add.push("right-down");	add.push("right-up");}
		}
		else
		{
			if( this.cycleIndex==0){ add.push("up");}
			else	if( this.cycleIndex==1){ add.push("left");}
			else	if( this.cycleIndex==2){ add.push("down");}
			else	if( this.cycleIndex==3){ add.push("right");}
		}
	}
	else	if( this.myCycle.cycleType == 3)
	{
		if( this.children.length > 2)
		{
			if( this.cycleIndex==0){ add.push("right-up"); add.push("left-up");}
			else	if( this.cycleIndex==1){ add.push("left-up");	add.push("left-down");}
			else	if( this.cycleIndex==2){ add.push("right-down");	add.push("right-up");}
		}
		else
		{
			if( this.cycleIndex==0){ add.push("up"); add.push("up");}
			else	if( this.cycleIndex==1){ add.push("left-down");}
			else	if( this.cycleIndex==2){ add.push("right-down");}
		}
	}
	else
	{
		trace("mc2D CCycle.prototype.getCommonChildDirections error: unsupported cycle type " + this.cycleType);
	}
	if( cycleFCD.indexOf("down")!=-1)
	{
		rotateCount = 0;
	}
	else	if( cycleFCD.indexOf("up")!=-1)
	{
		rotateCount = 2;
	}
	else	if( cycleFCD == "right")
	{
		rotateCount = 3;
	}
	else	if( cycleFCD == "left")
	{
		rotateCount = 1;
	}
	else
	{
		trace("mc2D CCycleAtom.prototype.getCommonChildDirections error: incorrect firstChildDirection " + cycleFCD);
	}
	if( this.isFlipped && add.length==2)
	{
		var temp=add[0];
		add[0] = add[1];
		add[1] = temp;
	}
	if( rotateCount != 0)
	{
		for(var i=0; i<add.length;i++)
		{
			var addi = add[i];
			for( var j=0; j<sides.length; j++)
			{
				if( addi == sides[j])
				{
					j += rotateCount*2;
					j %= sides.length;
					add[i] = sides[j];
					break;
				}
			}
		}

	}
	return add;
}
//    "" 
CCycleAtom.prototype.CAtom_getLockedLinks = CAtom.prototype.getLockedLinks;
CCycleAtom.prototype.getLockedLinks = function()
{
	var locked = 0;
	if( this.cycleIndex==0 || this.isTail)	 //    
	{
		locked = this.myCycle.getLockedLinks();
	}
	else
		locked = this.CAtom_getLockedLinks();
	return locked;
}

//    
CCycleAtom.prototype.CAtom_createVisual = CAtom.prototype.createVisual;
CCycleAtom.prototype.createVisual = function(atomType)
{
	if( this.myCycle!=null && this.cycleIndex==0)
	{
		this.parent = this.myCycle;
		this.CAtom_createVisual(atomType);
		this.parent = null;
	}
	else
	{
		this.CAtom_createVisual(atomType);
	}
}
//    
CCycleAtom.prototype.CAtom_loadLinkImage = CAtom.prototype.loadLinkImage;
CCycleAtom.prototype.loadLinkImage=function()
{
//trace("loadLinkImage for "+this.type);
if( this.parent!=null)
	trace("loadLinkImage parent = "+this.parent.type);
	if( this.myCycle!=null && this.myCycle.parent==null && this.cycleIndex==0)
	{
		if( this.oLink!=null)
			this.oLink.hide();
		return;
	}
//trace("Loading...");
	this.CAtom_loadLinkImage();
}
//    ,   this   
CCycleAtom.prototype.getVisualInstance = function()
{
	return this.myCycle;
}
//    
CCycleAtom.prototype.CAtom_showH = CAtom.prototype.showH;
CCycleAtom.prototype.showH = function()
{
	this.CAtom_showH();
//trace("this.isTail="+this.isTail);
	if( this.isTail && this.oText!=null)
	{
		this.oText.hide();
	}
}
//       
CCycleAtom.prototype.allowAddition = function(atomType)
{
	return this.myCycle.allowAddition(atomType);
}
//   
CCycleAtom.prototype.CAtom_setLink = CAtom.prototype.setLink;
CCycleAtom.prototype.setLink=function(alinkType)
{
	if( this == this.myCycle.head())
	{
		this.myCycle.setLink( alinkType);
		this.linkType = this.myCycle.linkType;
		this.loadLinkImage();
	}
	else
		this.CAtom_setLink( alinkType);
}
//////////////////////////////////////////////////////////////////
//  ,  CAtom,     
//////////////////////////////////////////////////////////////////
function CCycle()
{
	this.cycleType = 6;	//    
	this.cycleChildren = new Array;	//     ,  
	////////////////////////////////////////////////
	this.children=new Array();
	this.type="C";
	this.parent=null;
	this.drawType=1;
	this.x=0;
	this.y=0;
	this.rootDistance=0;
	this.linkType=0;
	this.freeLinks=4;
	this.firstChildDirection="down";
	this.molecule=null;
	this.oText=null;
	this.oLink=null;
	this.longestChild=null;
	this.longestChildCount=0;
	this.isOnMainLine=false;
	this.subtreeLength=0;
	this.index=0;
	this.isFlipped=false;	//    180 .?
}

CCycle.prototype = new CAtom();
//   -
CCycle.prototype.CAtom_create = CAtom.prototype.create;
CCycle.prototype.create = function( atomType)
{
	var newCycle = new CCycle();
	if( typeof(atomType)!="string" || atomType.length<3 || atomType.indexOf(":")==-1)
	{
		trace("mc2D cycle creation error: incorrect cycle type ["+atomType+"]");
		return null;
	}
	var cells = atomType.split(":");
	var cycleType = cells[0];
	var cycleNumber = Number(cells[1]);

	newCycle.type = atomType;
	newCycle.cycleType = cycleNumber;

//trace("cycleType="+cycleType+", cycleNumber="+cycleNumber);

	if( cycleNumber<3 || cycleNumber>6)
	{
		trace("mc2D cycle creation error: incorrect cycle count ["+cycleNumber+"]");
		return null;
	}

	for( var i=0; i<cycleNumber + 1 /*for fake atom*/; i++)
	{
		//   - 
		//var newAtom = CCycleAtom.prototype.create(cycleType + "<sub>" + i + "</sub>");
		var newAtom = CCycleAtom.prototype.create(cycleType);
		newAtom.myCycle = newCycle;
		newAtom.cycleIndex = i;

		newCycle.cycleChildren.push( newAtom);
		if( i > 0)
		{
			newCycle.cycleChildren[i-1].addChild( newCycle.cycleChildren[i]);
		}
		if( i == cycleNumber)
		{
			newAtom.isTail = true;
		}
	}
	//newCycle.addChild( newCycle.cycleChildren[0]);
	newCycle.children.length = 0;

	/*for(var i=0; i<newCycle.cycleChildren.length;i++)
	{
		var cycleChild = newCycle.cycleChildren[i];
		trace("cycleChild = "+cycleChild.type);
		for(var j=0; j<cycleChild.children.length;j++)
		{
			trace("   cycleChild child = "+cycleChild.children[j].type);
		}
	}*/

	return newCycle;
};
//   
CCycle.prototype.CAtom_removeChild = CAtom.prototype.removeChild;
CCycle.prototype.removeChild = function(atom)
{
	return this.CAtom_removeChild( atom);
}
//      ,  
CCycle.prototype.getOccupiedBoardCells = function()
{
	var cells = new Array();
	// ,  
	var obj = new Object();
		obj.x = this.getAbsX();
		obj.y = this.getAbsY();
	var k=2;
	var cycleFCD = this.firstChildDirection;

	var cellsX = null;
	var cellsY = null;

	if( this.cycleType == 6)
	{
		if( cycleFCD.indexOf("down")!=-1)
		{											//__1__
			cellsX = new Array(0,-1,-1,0,1,1,0);	//_2_6_
			cellsY = new Array(0,1,2,3,2,1,0);		//_3_5_
		}											//__4__
		else	if( cycleFCD.indexOf("up")!=-1)
		{											//__4__
			cellsX = new Array(0,1,1,0,-1,-1,0);	//_5_3_
			cellsY = new Array(0,-1,-2,-3,-2,-1,0);	//_6_2_
		}											//__1__
		else	if( cycleFCD == "right")
		{
			cellsX = new Array(0,1,2,3,2,1,0);		//_6_5_
			cellsY = new Array(0,1,1,0,-1,-1,0);	//1___4
		}											//_2_3_
		else	if( cycleFCD == "left")
		{
			cellsX = new Array(0,-1,-2,-3,-2,-1,0);	//_3_2_
			cellsY = new Array(0,-1,-1,0,1,1,0);	//4___1
		}											//_5_6_
		else
		{
			trace("mc2D CCycle.prototype.getOccupiedBoardCells error: incorrect firstChildDirection " + cycleFCD);
		}
	}
	else	if( this.cycleType == 5)
	{
		if( cycleFCD.indexOf("down")!=-1)
		{											//__1__
			cellsX = new Array(0,-1,-1,1,1,0);		//_2_5_
			cellsY = new Array(0,1,2,2,1,0);		//_3_4_
		}
		else	if( cycleFCD.indexOf("up")!=-1)
		{
			cellsX = new Array(0,1,1,-1,-1,0);		//_4_3_
			cellsY = new Array(0,-1,-2,-2,-1,0);	//_5_2_
		}											//__1__
		else	if( cycleFCD == "right")
		{
			cellsX = new Array(0,1,2,2,1,0);		//_5_4_
			cellsY = new Array(0,1,1,-1,-1,0);		//1___
		}											//_2_3_
		else	if( cycleFCD == "left")
		{
			cellsX = new Array(0,-1,-2,-2,-1,0);	//_3_2_
			cellsY = new Array(0,-1,-1,1,1,0);		//____1
		}											//_4_5_
		else
		{
			trace("mc2D CCycle.prototype.getOccupiedBoardCells error: incorrect firstChildDirection " + cycleFCD);
		}
	}
	else	if( this.cycleType == 4)
	{
		if( cycleFCD.indexOf("down")!=-1)
		{											//__1__
			cellsX = new Array(0,-1,0,1,0);			//_2_4_
			cellsY = new Array(0,1,2,1,0);			//__3__
		}
		else	if( cycleFCD.indexOf("up")!=-1)
		{
			cellsX = new Array(0,1,0,-1,0);			//__3__
			cellsY = new Array(0,-1,-2,-1,0);		//_4_2_
		}											//__1__
		else	if( cycleFCD == "right")
		{
			cellsX = new Array(0,1,2,1,0);			//__4__
			cellsY = new Array(0,1,0,-1,0);			//1__3
		}											//_2___
		else	if( cycleFCD == "left")
		{
			cellsX = new Array(0,-1,-2,-1,0);		//___2_
			cellsY = new Array(0,-1,0,1,0);			//_3__1
		}											//__4__
		else
		{
			trace("mc2D CCycle.prototype.getOccupiedBoardCells error: incorrect firstChildDirection " + cycleFCD);
		}
	}
	else	if( this.cycleType == 3)
	{
		if( cycleFCD.indexOf("down")!=-1)
		{											//__1__
			cellsX = new Array(0,-1,1,0);			//_2_3_
			cellsY = new Array(0,1,1,0);
		}
		else	if( cycleFCD.indexOf("up")!=-1)
		{
			cellsX = new Array(0,1,-1,0);
			cellsY = new Array(0,-1,-1,0);			//_3_2_
		}											//__1__
		else	if( cycleFCD == "right")
		{
			cellsX = new Array(0,1,1,0);			//__3__
			cellsY = new Array(0,1,-1,0);			//1____
		}											//_2___
		else	if( cycleFCD == "left")
		{
			cellsX = new Array(0,-1,-1,0);			//___2_
			cellsY = new Array(0,-1,1,0);			//____1
		}											//__3__
		else
		{
			trace("mc2D CCycle.prototype.getOccupiedBoardCells error: incorrect firstChildDirection " + cycleFCD);
		}
	}
	else
	{
		trace("mc2D CCycle.prototype.getOccupiedBoardCells error: incorrect cycle type " + this.cycleType);
	}
	if( cellsX==null || cellsY==null || cellsX.length!=cellsY.length)
	{
		trace("mc2D CCycle.prototype.getOccupiedBoardCells error: cellsX.length!=cellsY.length " + cellsX.length+","+cellsY.length);
	}
	for( var i=0; i<cellsX.length; i++)
	{
		var cell = new Object();
		cell.x = obj.x + k*cellsX[i];
		cell.y = obj.y + k*cellsY[i];
		cells.push( cell);// 1
	}

	return cells;
}
//   X
CCycle.prototype.CAtom_setX = CAtom.prototype.setX;
CCycle.prototype.setX=function(ax)
{
	this.CAtom_setX( ax);
	var cells = this.getOccupiedBoardCells();
	if( cells.length != this.cycleChildren.length)
	{
		trace("mc2D CCycle setX error:cells.length != this.cycleChildren.length["+cells.length+","+this.cycleChildren.length+"]");
		return;
	}
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.setX( cells[i].x - this.molecule.x);
//trace("childX ["+child.type+"]="+child.x);
	}
}
//   Y
CCycle.prototype.CAtom_setY = CAtom.prototype.setY;
CCycle.prototype.setY=function(ay)
{
	this.CAtom_setY( ay);
	var cells = this.getOccupiedBoardCells();
	if( cells.length != this.cycleChildren.length)
	{
		trace("mc2D CCycle setY error:cells.length != this.cycleChildren.length["+cells.length+","+this.cycleChildren.length+"]");
		return;
	}
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.setY( cells[i].y - this.molecule.y);
//trace("childY ["+child.type+"]="+child.y);
	}
}
//    
CCycle.prototype.CAtom_createVisual = CAtom.prototype.createVisual;
CCycle.prototype.createVisual = function(atomType)
{
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		this.cycleChildren[i].molecule = this.molecule;
		this.cycleChildren[i].createVisual();
	}
	this.CAtom_createVisual("");
	if( this.oText!=null)	this.oText.hide();
	if( this.oLink!=null)	this.oLink.hide();
}
//     
CCycle.prototype.CAtom_setFirstChildDirection = CAtom.prototype.setFirstChildDirection;
CCycle.prototype.setFirstChildDirection = function(aDir)
{
//trace("aDir="+aDir);
	this.CAtom_setFirstChildDirection(aDir);
	this.updateInternalChildDirections();
}
//
CCycle.prototype.updateInternalChildDirections = function()
{
//trace("updateInternalChildDirections="+this.firstChildDirection);
	var dirs = new Array();
	var cycleFCD = this.firstChildDirection;

	if( this.cycleType>=3 && this.cycleType<=6)
	{
		var cells = this.getOccupiedBoardCells();
		if( cells.length == 0)
		{
			trace("mc2D CCycle.prototype.getCommonChildDirections error: cells.length == 0");
			return add;
		}
		dirs.push(this.firstChildDirection);// 1
		var stX = cells[0].x;
		var stY = cells[0].y;
		for( var i=1; i<cells.length; i++)
		{
			var dir = "";
			var cellX = cells[i].x;
			var cellY = cells[i].y;
			if( cellX > stX)	dir = "right";
			else	if( cellX < stX)	dir = "left";
			if( cellY!=stY && dir!="")	dir += "-";
			if( cellY > stY)	dir += "down";
			else	if( cellY < stY)	dir += "up";
			stX = cellX;
			stY = cellY;
			dirs.push( dir);
		}
	}
	else
	{
		trace("mc2D CCycle.prototype.getCommonChildDirections error: unsupported cycle type " + this.cycleType);
	}

	if( dirs.length != this.cycleChildren.length)
	{
		trace("mc2D CCycle updateInternalChildDirections error:dirs.length != this.cycleChildren.length["+dirs.length+","+this.cycleChildren.length+"]");
		return;
	}

	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.firstChildDirection = dirs[i];
	}
}
//   
CCycle.prototype.getBounds = function()
{
	var bounds=new Object();
		bounds.left = 10000;
		bounds.right = -10000;
		bounds.top = 10000;
		bounds.bottom = -10000;
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		var childBounds = this.cycleChildren[i].getBounds();
		if( bounds.left>childBounds.left)		bounds.left=childBounds.left;
		if( bounds.top>childBounds.top)			bounds.top=childBounds.top;
		if( bounds.right<childBounds.right)		bounds.right=childBounds.right;
		if( bounds.bottom<childBounds.bottom)	bounds.bottom=childBounds.bottom;
	}
	return bounds;
}
//   
CCycle.prototype.calculateLengths=function()
{
	this.longestChildCount = 0;
	this.longestChild = null;
}
//       
CCycle.prototype.CAtom_calculateDistances = CAtom.prototype.calculateDistances;
CCycle.prototype.calculateDistances = function()
{
	this.CAtom_calculateDistances();
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.rootDistance = this.rootDistance + 1;
	}
}
//    ,       
CCycle.prototype.optimizeLongestChildCount = function()
{
	return 0;
}
//     
CCycle.prototype.copyFrom = function(atom)
{
//trace("***************CCycle.prototype.copyFrom*****************");
	this.type = atom.type;
	this.cycleType = atom.cycleType;
	this.linkType = atom.linkType;
	this.isFlipped = atom.isFlipped;
//trace("atom.cycleChildren.length="+atom.cycleChildren.length);
	for( var i=0; i<atom.cycleChildren.length; i++)
	{
		var cycleAtom = new CCycleAtom();
		cycleAtom.myCycle = this;
		cycleAtom.copyFrom( atom.cycleChildren[i]);

		atom.cycleChildren[i].createdCopy = cycleAtom;

		this.cycleChildren.push( cycleAtom);
		cycleAtom.cycleIndex = i;

		if( i > 0)
		{
			this.cycleChildren[i-1].addChild( cycleAtom);
		}
		cycleAtom.isTail = atom.cycleChildren[i].isTail;
	}
	//this.addChild( this.cycleChildren[0]);
	this.children.length = 0;
//trace("this.children.length="+this.children.length);
}
//   
CCycle.prototype.setTextStyle = function(stl)
{
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.setTextStyle( stl);
	}
}
//      
CCycle.prototype.getElementCount = function(elem)
{
//trace("getElementCount="+elem + ":" + this.getType());
	var count = 0;
	for( var i=0; i<this.cycleChildren.length-1; i++)
	{
		var child = this.cycleChildren[i];
//trace("child.type="+child.type);
		count += child.getElementCount( elem);
//trace("count="+count);
	}
	return count;
}
//    
CCycle.prototype.head = function()
{
	return this.cycleChildren[0];
}
//     
CCycle.prototype.tail = function()
{
	return this.cycleChildren[this.cycleChildren.length-1];
}
//    
CCycle.prototype.destroy=function()
{
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.destroy();
	}
}
//    
CCycle.prototype.CAtom_addDrawType = CAtom.prototype.addDrawType;
CCycle.prototype.addDrawType = function( atype)
{
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.addDrawType( atype);
	}
	this.CAtom_addDrawType( atype);
}
//    
CCycle.prototype.CAtom_removeDrawType = CAtom.prototype.removeDrawType;
CCycle.prototype.removeDrawType = function( atype)
{
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.removeDrawType( atype);
	}
	this.CAtom_removeDrawType( atype);
}
//     
CCycle.prototype.CAtom_setDrawStyle = CAtom.prototype.setDrawStyle;
CCycle.prototype.setDrawStyle = function( atype)
{
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.setDrawStyle( atype);
	}
	this.CAtom_setDrawStyle( atype);
}
//     
CCycle.prototype.CAtom_setExtendedDrawStyle = CAtom.prototype.setExtendedDrawStyle;
CCycle.prototype.setExtendedDrawStyle = function( atype)
{
	for( var i=0; i<this.cycleChildren.length; i++)
	{
		var child = this.cycleChildren[i];
		child.setExtendedDrawStyle( atype);
	}
	this.CAtom_setExtendedDrawStyle( atype);
}
//    "" 
CCycle.prototype.getLockedLinks = function()
{
	var locked = 0;
	var myRoot = this.cycleChildren[0];
trace("myRoot.type = " + myRoot + ":" + myRoot.children.length);
	for( var i=0; i<myRoot.children.length; i++)
	{
		locked += myRoot.children[i].linkType;
		trace("locked = " + locked);
	}
trace("this.linkType = " + this.linkType);
	if( this.parent!=null)
		locked += this.linkType;
trace("this.tail().linkType = " + this.tail().linkType);
	locked += this.tail().linkType;
	return locked;
}
//       
CCycle.prototype.containsCycleChild = function()
{
	if( this.parent!=null && (this.parent instanceof CCycleAtom))
	{
		return true;
	}
	for( var i=0; i<this.children.length; i++)
	{
		var child = this.cycleChildren[i];
		if( child instanceof CCycleAtom || child instanceof CCycle)
		{
			return true;
		}
	}
	return false;
}
CCycle.prototype.allowAddition = function(atomType)
{
	if( CAtom.prototype.isSpecialCycleType( atomType) ||
		CAtom.prototype.isCycleType(atomType))
	{
		this.molecule.board.onWarning(12);
		return false;
	}
	return true;
	/*
	//     ""      
	if( this.containsCycleChild())
	{
		this.molecule.board.onWarning(12);
		return false;
	}
	return true;
	*/
}
//    
CCycle.prototype.makeHead = function(atom)
{
trace("***********makeHead***************:" + atom.type);
if( atom.parent != null)
{
	trace("Parent is:" + atom.parent.type);
}
	if( atom == null)
	{
		trace("mc2D CCycle.prototype.makeHead error: atom is NULL");
		return;
	}
	if( !(atom instanceof CCycleAtom))
	{
		trace("mc2D CCycle.prototype.makeHead error: atom is not an CCycleAtom instance");
		return;
	}
	if( atom.myCycle != this)
	{
		trace("mc2D CCycle.prototype.makeHead error: atom is from another cycle");
		return;
	}
	if( atom.cycleIndex==0)
	{
		trace("mc2D CCycle.prototype.makeHead warning: atom is already a cycle head");
		return;
	}
//trace("-----------------------1");
	// 1.     
	var newLastAtom = atom.parent;
	newLastAtom.removeChild( atom);
//trace("-----------------------2");
	// 2.   ""
	var tailLinkType = this.tail().linkType;
	var	lastAtom = this.tail().parent;
	var tail = this.tail();
	lastAtom.removeChild( this.tail());
	tail.destroy();
//trace("-----------------------3" + lastAtom.type + ":" + this.cycleChildren[0].type + ":" + this.cycleChildren[0].parent);
	// 3.   
	lastAtom.addChild( this.cycleChildren[0]);	this.children.pop();
	this.cycleChildren[0].linkType = tailLinkType;
//trace("-----------------------4");
	// 4.   
	//var newTail = CCycleAtom.prototype.create(this.type + "<sub>" + this.cycleChildren.length + "</sub>");
	var newTail = CCycleAtom.prototype.create(this.cycleChildren[0].getType());
		newTail.myCycle = this;
	newLastAtom.addChild(newTail);				this.children.pop();
//trace("-----------------------5" + newLastAtom.type + ":" + newLastAtom.children.length);
	// 5.  
	this.cycleChildren.length = 0;
	var temp = newTail;
//return;
	var array = new Array();
	while( temp!=null)
	{
		array.push( temp);
		temp = temp.parent;
	}
//trace("New cycle is:");
	for(var i=0; i<array.length; i++)
	{
		var child = array[array.length-1-i];
		child.cycleIndex = i;
		this.cycleChildren.push(child);
		if( i == array.length-1)
			child.isTail = true;
		else
			child.isTail = false;
//		trace("child["+i+"]=" + child.type + ":" + child.children.length);
	}
}