//      
CMolecule.prototype.clearMarks=function()
{
	this.markedRoot = null;
	this.calcTopDown(this.wfClearMarks);
}
CMolecule.prototype.wfClearMarks=function(atom)
{
	atom.isMarked = false;
}

//     ,     
//      
CMolecule.prototype.getBiggestSubtreeRoot = function(atom)
{
	if( atom.parent==null && atom.children.length==0)	return null;

	// 1.     
	this.calcBottomUp( this.wfCalcSubtreeLength);

	// 2. ,    
	var	minCount = 0;
	var	minAtom  = null;

	for( var i=0;i<atom.children.length;i++)
	{
		if( atom.children[i].subtreeLength > minCount)
		{
			minCount = atom.children[i].subtreeLength;
			minAtom = atom.children[i];
		}
	}

	if( atom.parent == null)
	{
		return minAtom;
	}

	var	parentMinCount = this.root.subtreeLength - atom.subtreeLength - 1;
	minAtom = parentMinCount>=minCount?atom.parent : minAtom;
	return minAtom;
}

//    ,    
CMolecule.prototype.markSmallestSubtree = function(atom)
{
//trace("markSmallestSubtree");
	this.clearMarks();
//trace("1");
	atom = atom.getVisualInstance();
	this.markedRoot = atom;
	var biggestRoot = this.getBiggestSubtreeRoot( atom);
	if( biggestRoot == null)
	{
//trace("2");
		this.calcTopDown( this.markAtom, atom);
		return;
	}
//trace("3");
	if( biggestRoot == atom.parent)
	{
//trace("4");
		this.calcTopDown( this.markAtom, atom);
		return;
	}
	else
	{
//trace("5");
		this.stopNode = biggestRoot;
		this.calcTopDownWithStop( this.markAtom);
	}
//trace("6");
}
//    ,    
CMolecule.prototype.markAtom = function(atom)
{
	atom.isMarked=true;
}

//       
CMolecule.prototype.grabMarkedAtomsToArray = function()
{
	this.aMarked = new Array();
	this.calcTopDownMarked(this.wfGrabMarkedAtomsToArray);
}
CMolecule.prototype.wfGrabMarkedAtomsToArray = function(atom)
{
	this.aMarked.push( atom);
}