//////////////////////////////////////////////////////////////////
//  
//////////////////////////////////////////////////////////////////
this.borderCellsCount = 2;
this.widthCellsCount = 100;
this.heightCellsCount = 30;
this.cells = new Array();

var i=0;
for(; i<this.heightCellsCount+2*this.borderCellsCount; i++)
{
	var oneLineCells = new Array();
	var j=0;
	for(; j<this.widthCellsCount+2*this.borderCellsCount; j++)
	{
		oneLineCells.push( true);
	}
	this.cells.push(oneLineCells);
}

//      
function checkBounds(realX, realY)
{
	if( realX<0 || realX>=this.widthCellsCount+2*this.borderCellsCount)
	{
		trace("mc2D board error: X is out of board bounds["+realX+"]");
		return false;
	}
	if( realY<0 || realY>=this.heightCellsCount+2*this.borderCellsCount)
	{
		trace("mc2D board error: Y is out of board bounds["+realY+"]");
		return false;
	}
	return true;
}

// ,    
function cellIsEmpty(cellX, cellY)
{
	var realX = Math.floor(cellX + this.borderCellsCount);
	var realY = Math.floor(cellY + this.borderCellsCount);
	if( !this.checkBounds(realX, realY))
	{
		return false;
	}
	/*
	if( this.cells[realY][realX])
		trace( "cells["+cellX+","+cellY+"] is empty");
	else
		trace( "cells["+cellX+","+cellY+"] is busy");
	*/
//trace("realY="+realY);
	return this.cells[realY][realX];
}

function markCell(cellX, cellY, val)
{
	var realX = Math.floor(cellX + this.borderCellsCount);
	var realY = Math.floor(cellY + this.borderCellsCount);
	if( !this.checkBounds(realX, realY))
	{
		return;
	}
	this.cells[realY][realX] = val;
	//if( this.cells[realY][realX])
	//	trace( "cells["+cellX+","+cellY+"] is empty now");
	//else
	//	trace( "cells["+cellX+","+cellY+"] is busy now");
}

//    
function markCellAsBusy(cellX, cellY)
{
	cellX = Math.floor(cellX);
	cellY = Math.floor(cellY);
	this.markCell(cellX, cellY, false);
}

//    
function markCellAsEmpty(cellX, cellY)
{
	cellX = Math.floor(cellX);
	cellY = Math.floor(cellY);
	this.markCell(cellX, cellY, true);
}

//     
function clear()
{
	var i=-this.borderCellsCount;
	for( ;i<this.widthCellsCount+this.borderCellsCount;i++)
	{
		var j=-this.borderCellsCount;
		for( ;j<this.heightCellsCount+this.borderCellsCount;j++)
		{
			this.markCellAsEmpty( i, j);
			//this.markCellAsBusy( i, j);
		}
	}
	/*
	this.markCellAsEmpty( 11, 5);
	this.markCellAsEmpty( 10, 5);
	this.markCellAsEmpty( 9, 5);
	this.markCellAsEmpty( 9, 4);
	*/
}

//   
function getCellXY(cellX, cellY)
{
	var ret = new Object();
	ret.x = cellX*this.cellSizeX;
	ret.y = cellY*this.cellSizeY;
	return ret;
}

//   
function getXYCell(ax, ay)
{
	var ret = new Object();
	ret.x = ax/this.cellSizeX;
	ret.y = ay/this.cellSizeY;
	return ret;
}