//   O
//  //
//-C
//  \
//   H
gpGroup1 = '<?xml version="1.0" encoding="UTF-8"?><isomer><molecule name="Some name"><atom type="C"><atom type="O" link="double"/><atom type="H"/></atom></molecule></isomer>';
gpGroup2 = '<?xml version="1.0" encoding="UTF-8"?><isomer><molecule name="Some name"><atom type="OH"/></molecule></isomer>';
gpGroup3 = '<?xml version="1.0" encoding="UTF-8"?><isomer><molecule name="Some name"><atom type="C"><atom type="O" link="double"/><atom type="O"/></atom></molecule></isomer>';
gpGroup4 = '<?xml version="1.0" encoding="UTF-8"?><isomer><molecule name="Some name"><atom type="NO2"/></molecule></isomer>';
gpGroup5 = '<?xml version="1.0" encoding="UTF-8"?><isomer><molecule name="Some name"><atom type="NH2"/></molecule></isomer>';
gpGroup6 = '<?xml version="1.0" encoding="UTF-8"?><isomer><molecule name="Some name"><atom type="Cl"/></molecule></isomer>';
gpGroup7 = '<?xml version="1.0" encoding="UTF-8"?><isomer><molecule name="Some name"><atom type="Br"/></molecule></isomer>';

// Проверяет, является ли атом одним из атомов концевой группы
// Возможны следующие ситуации:
// 1.
//   group
//  /
//-C
//  \
//   group
// 2.
//O[*][root]
// \
//  C-
// /
//O
// 3.
//O[root]
// \
//  C-
// /
//O[*]
// 4.
//O[*]
// \
//  C[root]-
// /
//O[*]
CAtom.prototype.isInGroup = function()
{
	// Углерод не может быть концевым атомом цикла
	if( this.getType() == "C")	return 0;

	if( groupsDebugInfo)
		trace("----Check isInGroup for atom:"+this.type);

	if( this.parent!=null)
	{
		// 3.
		if( this.parent.parent!=null && this.parent.parent.isInGroup()==2)
		{
			if( groupsDebugInfo)
				trace("InGroup type = 3");
			return 3;
		}
		if( this.parent.getType()=="C" || this.parent.getType()=="N")
		{
			// 1.
			if( this.parent.parent!=null && this.parent.children.length==2)
			{
				if( this.parent.children[0].getType()!="C" &&
					this.parent.children[1].getType()!="C")
				{
					if( groupsDebugInfo)
						trace("InGroup type = 1");
					return 1;
				}
			}
			else	if( this.parent.parent==null && this.parent.children.length==3)
			{
				// 4.
				return 4;
			}
		}
	}
	else
	{
		// 2.
		if( this.children.length == 1)
		{
			var child = this.children[0];
			if( child.children.length == 2)
			{
				if( child.children[0].getType()!="C" ||
					child.children[1].getType()!="C")
				{
					if( groupsDebugInfo)
						trace("InGroup type = 2");
					return 2;
				}
			}
		}
	}
	if( groupsDebugInfo)
		trace("InGroup type = 0");
	return 0;
}

// Содержит ли атом дочерние элементы не H типа
CAtom.prototype.containNonHElements = function()
{
	for( var i=0; i<this.children.length; i++)
		if( this.children[i].getType() != "H")
			return true;
	return false;
}

// Является ли атом началом группы
CAtom.prototype.isGroupHead = function()
{
	if( this.getType() != "C" && this.getType() != "N")	return false;

	if( groupsDebugInfo)
		trace("----Check isGroupHead for atom:"+this.type);
	// 1.
	if( this.parent!=null)
	{
		for( var i=0; i<this.children.length; i++)
			if( !this.children[i].isInGroup())
				break;
		if( i == this.children.length && this.children.length!=0)
		{
			if( groupsDebugInfo)
				trace("isGroupHead type = 1");
			return true;
		}
	}
	else
	{
		// 4.
		if( this.children.length == 3)
		{
			var inGroupChildren = 0;
			for( var i=0; i<this.children.length; i++)
				if( this.children[i].isInGroup()>0 && !this.children[i].isGroupHead())
					inGroupChildren++;
			if( inGroupChildren == 2)
			{
				if( groupsDebugInfo)
					trace("isGroupHead type = 4");
				return true;
			}
		}
	}
	// 2[3]
	if( this.parent==null || !this.parent.isInGroup())
	{
		return false;
	}
	if( groupsDebugInfo)
		trace("isGroupHead type = 2[3]");
	return true;
}